UNIT GLTexture;

{ GLTexture   - This units handles all the texture stuff.
  Version     - 0.2.25
  Last Change - 26 June 1997
  for more information see help file
}

INTERFACE

USES Classes, CommCtrl, DsgnIntf, GL, GLU, Graphics, Windows;

TYPE TPixelArray  = ARRAY[0..0] OF Byte;
     PPixelArray  = ^TPixelArray;
     TTextureMode = (tmDecal,tmModulate,tmBlend,tmReplace);
     TTextureWrap = (twBoth,twNone,twVertical,twHorizontal);
     TMinFilter   = (miNearest,miLinear,miNearestMipmapNearest,miLinearMipmapNearest,
                     miNearestMipmapLinear,miLinearMipmapLinear);
     TMagFilter   = (maNearest,maLinear);
     
     TTexture     = CLASS(TPersistent)
     PRIVATE
       FOwner       : TComponent;
       FTextureMode : TTextureMode;
       FTextureWrap : TTextureWrap;
       FMinFilter   : TMinFilter;
       FMagFilter   : TMagFilter;
       FBitmap      : Graphics.TBitmap;
       PROCEDURE SetBitmap(ABitmap: Graphics.TBitmap);
     PUBLIC
       CONSTRUCTOR Create(AOwner: TComponent);
       DESTRUCTOR  Destroy; OVERRIDE;
       PROCEDURE Apply;
     PUBLISHED
       PROPERTY Bitmap: Graphics.TBitmap READ FBitmap WRITE SetBitmap;
       PROPERTY TextureMode: TTexturemode READ FTextureMode WRITE FTextureMode;
       PROPERTY TextureWrap: TTextureWrap READ FTextureWrap WRITE FTextureWrap;
       PROPERTY MinFilter: TMinFilter READ FMinFilter WRITE FMinFilter;
       PROPERTY MagFilter: TMagFilter READ FMagFilter WRITE FMagFilter;
     END;

     TTextureEditor = CLASS(TComponentProperty)
     PROTECTED
       FUNCTION GetAttributes: TPropertyAttributes; OVERRIDE;
     END;

//------------------------------------------------------------------------------

IMPLEMENTATION

USES GLScene;

//------------------------------------------------------------------------------

PROCEDURE TTexture.SetBitmap(ABitmap: Graphics.TBitmap);

BEGIN
  FBitmap.Assign(ABitmap);
  IF FOwner IS TSceneObject THEN
  WITH FOwner AS TSceneObject DO
  BEGIN
    Changed:=True;
    Scene.NotifyChange;
  END;
END;

//------------------------------------------------------------------------------

CONSTRUCTOR TTexture.Create(AOwner: TComponent);

BEGIN
  INHERITED Create;
  FOwner:=AOwner;
  FBitmap:=Graphics.TBitmap.Create;
END;

//------------------------------------------------------------------------------

DESTRUCTOR TTexture.Destroy;

BEGIN
  FBitmap.Free;
  INHERITED Destroy;
END;

//------------------------------------------------------------------------------

PROCEDURE TTexture.Apply;

VAR Data        : PPixelArray;
    BMInfo      : TBITMAPINFO;
    ImageInfo   : TIMAGEINFO;
    I,ImageSize : Integer;
    Temp        : Byte;

BEGIN
  WITH FBitmap DO
  TRY
    ImageSize:=Width*Height;
    Getmem(Data,ImageSize*3);
    WITH BMinfo.bmiHeader DO
    BEGIN
      biSize:=sizeof(TBitmapInfoHeader);
      biBitCount:=24;
      biWidth:=Width;
      biHeight:=-Height;
      biPlanes:=1;
      biCompression:=BI_RGB;
    END;
    GetDIBits(Canvas.Handle,Handle,0,Height,Data,BMInfo,DIB_RGB_COLORS);
{$R-}
    FOR I:=0 TO ImageSize-1 DO //swap blue with red to go from bgr to rgb
    BEGIN
      Temp:=Data^[I*3];
      Data^[I*3]:=Data^[I*3+2];
      Data^[I*3+2]:=Temp;
    END;
{$R-}
    glPixelStorei(GL_UNPACK_ALIGNMENT,4);
    glPixelStorei(GL_UNPACK_ROW_LENGTH,0);
    glPixelStorei(GL_UNPACK_SKIP_ROWS,0);
    glPixelStorei(GL_UNPACK_SKIP_PIXELS,0);

    CASE FTextureWrap OF
      twBoth       : BEGIN
                       glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_REPEAT);
                       glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_REPEAT);
                     END;
      twNone       : BEGIN
                       glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_CLAMP);
                       glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_CLAMP);
                     END;
      twHorizontal : BEGIN
                       glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_REPEAT);
                       glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_CLAMP);
                     END;
      twVertical   : BEGIN
                       glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_CLAMP);
                       glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_REPEAT);
                     END;
    END;

    CASE FMinFilter OF
      miNearest              : glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_NEAREST);
      miLinear               : glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
      miNearestMipmapNearest : glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_NEAREST_MIPMAP_NEAREST);
      miLinearMipmapNearest  : glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR_MIPMAP_NEAREST);
      miNearestMipmapLinear  : glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_NEAREST_MIPMAP_LINEAR);
      miLinearMipmapLinear   : glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR_MIPMAP_LINEAR);
    END;

    CASE FMagFilter OF
      maNearest : glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_NEAREST);
      maLinear  : glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
    END;

    CASE FTextureMode OF
      tmDecal    : glTexEnvf(GL_TEXTURE_ENV,GL_TEXTURE_ENV_MODE,GL_DECAL);
      tmModulate : glTexEnvf(GL_TEXTURE_ENV,GL_TEXTURE_ENV_MODE,GL_MODULATE);
      tmBlend    : glTexEnvf(GL_TEXTURE_ENV,GL_TEXTURE_ENV_MODE,GL_BLEND);
      tmReplace  : glTexEnvf(GL_TEXTURE_ENV,GL_TEXTURE_ENV_MODE,GL_REPLACE);
    END;

    IF (FMinFilter = miNearest) OR (FMinFilter = miLinear)
      THEN glTexImage2d(GL_TEXTURE_2D,0,3,Width,Height,0,GL_RGB,GL_UNSIGNED_BYTE,Data^)
      ELSE gluBuild2DMipmaps(GL_TEXTURE_2D,3,Width,Height,GL_RGB, GL_UNSIGNED_BYTE,Data^);
  FINALLY
    Freemem(Data);
  END;
END;

//------------------------------------------------------------------------------

FUNCTION TTextureEditor.GetAttributes: TPropertyAttributes;

BEGIN
  Result:=[paSubProperties];
END;

//------------------------------------------------------------------------------

END.
